Module Main

    '                              PD-2009
    '
    ' Programma per la pressoflessione deviata                      rev. 05.09
    '
    ' Programma scritto con Visual Basic 2005 Express Edition
    '
    ' Nota
    ' il programma attualmente non ha maschere di input e di output
    ' deve quindi essere usato seguendo le indicazioni qui riportate
    '
    ' Costanti
    ' sono definiti qui sotto come costanti alcuni parametri,
    ' che non dovrebbe essere necessario modificare
    ' (epsilon limite, modulo elastico, numero di elementi o di punti)
    '
    ' Dati di input
    ' sono assegnati all'interno del programma, all'inizio della Sub Main
    '
    ' Output
    ' i risultati vengono messi in pi file, con nome base assegnato all'interno
    ' del programma, all'inizio della Sub Main. Sono previsti:
    ' File ____x.txt    dominio Mx, N per My=0
    ' File ____y.txt    dominio My, N per Mx=0
    ' File ____mm1.txt  dominio Mx, My per un primo valore di N
    ' File ____mm2.txt  dominio Mx, My per un secondo valore di N
    ' File ____mm3.txt  dominio Mx, My per un terzo valore di N
    ' In uscita i valori di N sono espressi in N (dividere per 1000 per avere kN)
    ' quelli di M in Nmm (dividere per 1000000 per avere kNm)

    Const Infinito = 1.0E+20
    Const EpsC2 = 0.002, EpsCu2 = 0.0035, Es = 200000
    Const nEleCls = 100         ' numero di elementi di calcestruzzo
    Const nAlfa = 50            ' numero di alfa
    Const nPun = 150            ' numero di punti del diagramma

    ' Dati relativi al numero ed alla dimensione delle barre di armatura
    Structure DatiArmatura
        Dim DbSpiSup As Short   ' diametro barre spigolo sup, [mm]
        Dim NbSup As Short      ' numero barre superiori, escluso ferri di spigolo
        Dim DbSup As Short      ' diametro barre sup, escluso barre di spigolo [mm]
        Dim DbSpiInf As Short   ' diametro barre spigolo inf, [mm]
        Dim NbInf As Short      ' numero barre inferiori, escluso ferri di spigolo
        Dim DbInf As Short      ' diametro barre inferiori, [mm]
        Dim NbPar As Short      ' numero barre parete, solo su un lato
        Dim DbPar As Short      ' diametro barre parete,[mm]
    End Structure

    ' Dati relativi alle singole barre
    Structure Barra
        Dim Db As Short         ' diametro [mm]
        Dim A As Single         ' area [mm2]
        Dim x As Single         ' ascissa, riferimento x-y [mm]
        Dim y As Single         ' ordinata, riferimento x-y [mm]
        Dim x1 As Single        ' ascissa, riferimento x'-y' [mm]
        Dim y1 As Single        ' ordinata, riferimento x'-y' [mm]
    End Structure

    ' Dati relativi alla singola striscia di calcestruzzo
    Structure StrisciaCls
        Dim x1 As Single        ' ascissa estremo sinistro [mm]
        Dim x2 As Single        ' ascissa estremo destro [mm]
        Dim xC As Single        ' ascissa centro [mm]
        Dim yC As Single        ' ordinata centro [mm]
        Dim x1C As Single       ' ascissa centro, riferimento x'-y' [mm]
        Dim y1C As Single       ' ordinata centro, riferimento x'-y' [mm]
        Dim Dy As Single        ' altezza [mm]
        Dim A As Single         ' area [mm2]
    End Structure

    Sub Main()
        ' ------------------------------- dati da definire -------------------------------
        ' Dati relativi al materiale
        Dim fcd As Single = 14.14   ' fcd [MPa]
        Dim fyd As Single = 391.3   ' fyd [MPa]
        ' Dati relativi alla sezione
        ' i dati sotto riportati definiscono una sezione 30x70
        Dim b As Short = 300        ' base della sezione [mm]
        Dim h As Short = 700        ' altezza della sezione [mm]
        Dim c As Short = 40         ' copriferro della sezione [mm]
        ' Dati relativi all'armatura
        Dim Armatura As DatiArmatura
        Armatura.DbSpiSup = 20      ' diametro barre di spigolo superiori [mm] (qui: fi 20)
        Armatura.NbSup = 3          ' numero di barre lato superiore, oltre spigolo (qui: 3)
        Armatura.DbSup = 20         ' diametro barre lato superiore [mm] (qui: fi 20)
        Armatura.DbSpiInf = Armatura.DbSpiSup   ' diametro barre di spigolo inferiori [mm] (qui: = sup)
        Armatura.NbInf = Armatura.NbSup         ' numero di barre lato inferiore, oltre spigolo (qui: = sup)
        Armatura.DbInf = Armatura.DbSup         ' diametro barre lato inferiore [mm] (qui: = sup)
        Armatura.NbPar = 2          ' numero di barre di parete, oltre spigolo, per lato (qui: 2)
        Armatura.DbPar = 20         ' diametro barre di parete [mm] (qui: fi 20)
        ' Dati relativi all'output
        Dim Fout As String = "c:\ProvaPD09"     ' percorso e nome dei file di output (senza estensione)
        Dim Nass(3) As Single       ' sforzi normali per cui calcolare il dominio Mx,My
        Nass(1) = 0                 ' valori di N [kN] (positivi se compressione)
        Nass(2) = 500
        Nass(3) = 1000
        ' ------------------------------- fine dati da definire --------------------------
        ' Definizione delle singole barre
        Dim nBarre As Short = 0     ' numero di barre
        Dim Arm() As Barra          ' barre di armatura
        ReDim Arm(0)
        DefinisciBarre(Armatura, b, h, c, nBarre, Arm)
        ' Dati interni per definire la sezione ruotata e le epsilon
        Dim alfa As Single          ' angolo
        Dim h1 As Single            ' altezza della sezione ruotata [mm]
        Dim x As Single             ' distanza asse neutro-bordo [mm]
        Dim yN As Single            ' ordinata asse neutro [mm]
        Dim EleCls() As StrisciaCls
        ReDim EleCls(nEleCls)
        Dim Chi As Single, EpsG As Single, EpsInf As Single
        ' Dati relativi a sforzi normali e momenti flettenti
        Dim Ncls(nAlfa, nPun) As Single, Mxcls(nAlfa, nPun) As Single, Mycls(nAlfa, nPun) As Single
        Dim Nacc(nAlfa, nPun) As Single, Mxacc(nAlfa, nPun) As Single, Myacc(nAlfa, nPun) As Single
        Dim N(nAlfa, nPun) As Single, Mx(nAlfa, nPun) As Single, My(nAlfa, nPun) As Single
        ' Contatori per cicli
        Dim i As Short, k As Short, k1 As Short
        ' Determinazine del dominio Mx,My,N
        For i = 0 To nAlfa
            alfa = Math.PI / 2 * i / nAlfa
            DefinisciBarreRuotate(alfa, nBarre, Arm)
            DefinisciElementiCls(alfa, b, h, nEleCls, EleCls)
            h1 = h * Math.Cos(alfa) + b * Math.Sin(alfa)
            MN_Acc(-1, 0, nBarre, Arm, fyd, Mxacc(i, 0), Myacc(i, 0), Nacc(i, 0))
            For k = 1 To nEleCls
                x = h1 * k / nEleCls
                yN = h1 / 2 - x
                Chi = EpsCu2 / (h1 / 2 - yN)
                EpsG = -Chi * yN
                MN_Acc(EpsG, Chi, nBarre, Arm, fyd, Mxacc(i, k), Myacc(i, k), Nacc(i, k))
                MN_Cls(EpsG, Chi, nEleCls, EleCls, fcd, Mxcls(i, k), Mycls(i, k), Ncls(i, k))
            Next k
            For k1 = 1 To nPun - nEleCls
                k = k1 + nEleCls
                EpsInf = EpsC2 * k1 / (nPun - nEleCls)
                Chi = 7 / 4 * (EpsC2 - EpsInf) / h1
                EpsG = EpsC2 - Chi * h1 / 14
                MN_Acc(EpsG, Chi, nBarre, Arm, fyd, Mxacc(i, k), Myacc(i, k), Nacc(i, k))
                MN_Cls(EpsG, Chi, nEleCls, EleCls, fcd, Mxcls(i, k), Mycls(i, k), Ncls(i, k))
            Next k1
        Next i
        ' Output del dominio Mx,N per My=0
        Dim F As Short
        F = FreeFile()
        FileOpen(F, Fout & "x.txt", OpenMode.Output)
        i = 0
        For k = 0 To nPun
            Write(F, Mxacc(i, k), Myacc(i, k), Nacc(i, k), Mxcls(i, k), Mycls(i, k), Ncls(i, k))
            WriteLine(F)
        Next k
        FileClose(F)
        ' Output del dominio My,N per Mx=0
        F = FreeFile()
        FileOpen(F, Fout & "y.txt", OpenMode.Output)
        i = nAlfa
        For k = 0 To nPun
            Write(F, Mxacc(i, k), Myacc(i, k), Nacc(i, k), Mxcls(i, k), Mycls(i, k), Ncls(i, k))
            WriteLine(F)
        Next k
        FileClose(F)
        ' Output dei domini Mx,My per valori assegnati di N
        Dim N0 As Single
        Dim Mx_N(nAlfa) As Single, My_N(nAlfa) As Single
        Dim j As Short
        For j = 1 To 3
            N0 = Nass(j) * 1000
            If N0 < Ncls(0, 0) + Nacc(0, 0) Or N0 > Ncls(0, nPun) + Nacc(0, nPun) Then
                For i = 0 To nAlfa
                    Mx_N(i) = 0
                    My_N(i) = 0
                Next i
            Else
                For i = 0 To nAlfa
                    For k = 1 To nPun
                        If N0 < Ncls(i, k) + Nacc(i, k) Then
                            Mx_N(i) = ValInterpolato(Ncls(i, k - 1) + Nacc(i, k - 1), Mxcls(i, k - 1) + Mxacc(i, k - 1), Ncls(i, k) + Nacc(i, k), Mxcls(i, k) + Mxacc(i, k), N0)
                            My_N(i) = ValInterpolato(Ncls(i, k - 1) + Nacc(i, k - 1), Mycls(i, k - 1) + Myacc(i, k - 1), Ncls(i, k) + Nacc(i, k), Mycls(i, k) + Myacc(i, k), N0)
                            Exit For
                        End If
                    Next k
                Next i
            End If
            F = FreeFile()
            FileOpen(F, Fout & "mm" & Trim(Val(j)) & ".txt", OpenMode.Output)
            Write(F, N0)
            WriteLine(F)
            For i = 0 To nAlfa
                Write(F, Mx_N(i), My_N(i), Esponente(Mx_N(i) / Mx_N(0), My_N(i) / My_N(nAlfa)))
                WriteLine(F)
            Next i
            FileClose(F)
        Next j

    End Sub

    ' Definisce diametro, area e posizione delle singole barre
    Sub DefinisciBarre(ByVal Armatura As DatiArmatura, ByVal b As Short, ByVal h As Short, ByVal c As Short, ByRef nBarre As Short, ByRef Arm() As Barra)
        Dim nBcorr As Short, j As Short, Delta As Single
        nBarre = 4 + Armatura.NbSup + Armatura.NbInf + 2 * Armatura.NbPar
        ReDim Arm(nBarre)
        Arm(1).Db = Armatura.DbSpiSup
        Arm(1).x = -b / 2 + c
        Arm(1).y = h / 2 - c
        nBcorr = 1
        If Armatura.NbSup > 0 Then
            Delta = (b - 2 * c) / (Armatura.NbSup + 1)
            For j = 1 To Armatura.NbSup
                nBcorr = nBcorr + 1
                Arm(nBcorr).Db = Armatura.DbSup
                Arm(nBcorr).x = Arm(nBcorr - 1).x + Delta
                Arm(nBcorr).y = Arm(nBcorr - 1).y
            Next j
        End If
        nBcorr = nBcorr + 1
        Arm(nBcorr).Db = Armatura.DbSpiSup
        Arm(nBcorr).x = -Arm(1).x
        Arm(nBcorr).y = Arm(1).y
        nBcorr = nBcorr + 1
        Arm(nBcorr).Db = Armatura.DbSpiInf
        Arm(nBcorr).x = Arm(1).x
        Arm(nBcorr).y = -Arm(1).y
        If Armatura.NbInf > 0 Then
            Delta = (b - 2 * c) / (Armatura.NbInf + 1)
            For j = 1 To Armatura.NbInf
                nBcorr = nBcorr + 1
                Arm(nBcorr).Db = Armatura.DbInf
                Arm(nBcorr).x = Arm(nBcorr - 1).x + Delta
                Arm(nBcorr).y = Arm(nBcorr - 1).y
            Next j
        End If
        nBcorr = nBcorr + 1
        Arm(nBcorr).Db = Armatura.DbSpiInf
        Arm(nBcorr).x = -Arm(1).x
        Arm(nBcorr).y = Arm(nBcorr - 1).y
        If Armatura.NbPar > 0 Then
            Delta = (h - 2 * c) / (Armatura.NbPar + 1)
            For j = 1 To Armatura.NbPar
                nBcorr = nBcorr + 1
                Arm(nBcorr).Db = Armatura.DbPar
                Arm(nBcorr).x = Arm(1).x
                Arm(nBcorr).y = Arm(1).y - Delta * j
                nBcorr = nBcorr + 1
                Arm(nBcorr).Db = Armatura.DbPar
                Arm(nBcorr).x = -Arm(1).x
                Arm(nBcorr).y = Arm(1).y - Delta * j
            Next j
        End If
        For j = 1 To nBarre
            Arm(j).A = Math.PI * Arm(j).Db ^ 2 / 4
        Next j
    End Sub

    ' Fornisce le nuove coordinate dopo una rotazione di alfa
    Sub TrasformaCoordinate(ByVal alfa As Single, ByVal x As Single, ByVal y As Single, ByRef x1 As Single, ByRef y1 As Single)
        Dim CosA As Single, SinA As Single
        CosA = Math.Cos(alfa)
        SinA = Math.Sin(alfa)
        x1 = x * CosA + y * SinA
        y1 = y * CosA - x * SinA
    End Sub

    ' Fornisce i parametri m,n per una retta y=mx+n per due punti
    Sub RettaPer2punti(ByVal xA As Single, ByVal yA As Single, ByVal xB As Single, ByVal yB As Single, ByRef CoeffM As Single, ByRef CoeffN As Single)
        If xB <> xA Then
            CoeffM = (yB - yA) / (xB - xA)
            CoeffN = yA - xA * CoeffM
        Else
            CoeffM = Infinito
            CoeffN = -Infinito * xA
        End If
    End Sub

    ' Calcola gli estremi x dell'intersezione di retta y=cost con rettangolo
    ' A, B, C, D sono i punti di spigolo del rettangolo in senso orario (A sup)
    Sub IntersecaRettangolo(ByVal xP() As Single, ByVal yP() As Single, ByVal y As Single, ByRef x1 As Single, ByRef x2 As Single)
        Dim xP1 As Single, coeffM As Single, coeffN As Single
        Dim i As Short
        x1 = Infinito
        x2 = -Infinito
        For i = 0 To 3
            If y > Math.Min(yP(i), yP(i + 1)) And y < Math.Max(yP(i), yP(i + 1)) Then
                RettaPer2punti(xP(i), yP(i), xP(i + 1), yP(i + 1), coeffM, coeffN)
                If coeffM <> 0 Then xP1 = (y - coeffN) / coeffM Else xP1 = Infinito
                x1 = Math.Min(x1, xP1)
                x2 = Math.Max(x2, xP1)
            End If
        Next i
    End Sub

    ' Definisce gli elementi di calcestruzzo, con rotazione alfa
    Sub DefinisciElementiCls(ByVal alfa As Single, ByVal b As Single, ByVal h As Single, ByVal nEleCls As Single, ByRef EleCls() As StrisciaCls)
        Dim j As Short, jSimm As Short, Dy As Single
        Dim xP(4) As Single, yP(4) As Single
        TrasformaCoordinate(alfa, -b / 2, h / 2, xP(0), yP(0))
        TrasformaCoordinate(alfa, b / 2, h / 2, xP(1), yP(1))
        TrasformaCoordinate(alfa, b / 2, -h / 2, xP(2), yP(2))
        TrasformaCoordinate(alfa, -b / 2, -h / 2, xP(3), yP(3))
        xP(4) = xP(0)
        yP(4) = yP(0)
        Dy = yP(0) / (nEleCls / 2)
        For j = 1 To nEleCls / 2
            EleCls(j).y1C = yP(0) * (nEleCls / 2 - j + 0.5) / (nEleCls / 2)
            IntersecaRettangolo(xP, yP, EleCls(j).y1C, EleCls(j).x1, EleCls(j).x2)
            EleCls(j).x1C = (EleCls(j).x1 + EleCls(j).x2) / 2
            EleCls(j).Dy = Dy
            EleCls(j).A = (EleCls(j).x2 - EleCls(j).x1) * Dy
            TrasformaCoordinate(-alfa, EleCls(j).x1C, EleCls(j).y1C, EleCls(j).xC, EleCls(j).yC)
            jSimm = nEleCls + 1 - j
            EleCls(jSimm).x1 = -EleCls(j).x2
            EleCls(jSimm).x2 = -EleCls(j).x1
            EleCls(jSimm).xC = -EleCls(j).xC
            EleCls(jSimm).yC = -EleCls(j).yC
            EleCls(jSimm).x1C = -EleCls(j).x1C
            EleCls(jSimm).y1C = -EleCls(j).y1C
            EleCls(jSimm).Dy = EleCls(j).Dy
            EleCls(jSimm).A = EleCls(j).A
        Next j
    End Sub

    ' Deternmina le coordinate delle barre nel riferimento ruotato
    Sub DefinisciBarreRuotate(ByVal alfa As Single, ByVal nBarre As Short, ByRef Arm() As Barra)
        Dim j As Short
        For j = 1 To nBarre
            TrasformaCoordinate(alfa, Arm(j).x, Arm(j).y, Arm(j).x1, Arm(j).y1)
        Next j
    End Sub

    ' Calcola il contributo MN dell'acciaio per un diagramma assegnato
    Sub MN_Acc(ByVal EpsG As Single, ByVal Chi As Single, ByVal nBarre As Short, ByVal Arm() As Barra, ByVal fyd As Single, ByRef Mxacc As Single, ByRef Myacc As Single, ByRef Nacc As Single)
        Dim Eps As Single, Sig As Single, Nel As Single, j As Short
        Mxacc = 0
        Myacc = 0
        Nacc = 0
        For j = 1 To nBarre
            Eps = EpsG + Chi * Arm(j).y1
            Sig = SigmaAcc(Eps, fyd)
            Nel = Sig * Arm(j).A
            Nacc = Nacc + Nel
            Mxacc = Mxacc + Nel * Arm(j).y
            Myacc = Myacc - Nel * Arm(j).x
        Next j
    End Sub

    ' Calcola il contributo MN del calcestruzzo per un diagramma assegnato
    Sub MN_Cls(ByVal EpsG As Single, ByVal Chi As Single, ByVal nEleCls As Short, ByVal EleCls() As StrisciaCls, ByVal fcd As Single, ByRef Mxcls As Single, ByRef Mycls As Single, ByRef Ncls As Single)
        Dim Eps As Single, Sig As Single, Nel As Single, j As Short
        Mxcls = 0
        Mycls = 0
        Ncls = 0
        For j = 1 To nEleCls
            Eps = EpsG + Chi * EleCls(j).y1C
            Sig = SigmaCls(Eps, fcd)
            Nel = Sig * EleCls(j).A
            Ncls = Ncls + Nel
            Mxcls = Mxcls + Nel * EleCls(j).yC
            Mycls = Mycls - Nel * EleCls(j).xC
        Next j
    End Sub

    ' Determina la sigma nell'acciaio in funzione della epsilon
    Function SigmaAcc(ByVal Eps, ByVal fyd) As Single
        SigmaAcc = Eps * Es
        If SigmaAcc < -fyd Then
            SigmaAcc = -fyd
        ElseIf SigmaAcc > fyd Then
            SigmaAcc = fyd
        End If
    End Function

    ' Determina la sigma nel calcestruzzo in funzione della epsilon
    Function SigmaCls(ByVal Eps, ByVal fcd) As Single
        If Eps < 0 Then
            SigmaCls = 0
        ElseIf Eps < EpsC2 Then
            SigmaCls = Eps / EpsC2 * (2 - Eps / EpsC2) * fcd
        Else
            SigmaCls = fcd
        End If
    End Function

    Function ValInterpolato(ByVal x1, ByVal y1, ByVal x2, ByVal y2, ByVal x)
        ValInterpolato = y1 + (y2 - y1) * (x - x1) / (x2 - x1)
    End Function

    Function Esponente(ByVal rapp1, ByVal rapp2)
        Dim EspMin As Single, EspMax As Single, EspCorr As Single
        EspMin = 1
        EspMax = 100
        Do
            EspCorr = (EspMin + EspMax) / 2
            If rapp1 ^ EspCorr + rapp2 ^ EspCorr > 1 Then
                EspMin = EspCorr
            Else
                EspMax = EspCorr
            End If
        Loop Until EspMax - EspMin < 0.00001
        Esponente = EspCorr
    End Function

End Module
