/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;

public class WaveTheory
extends Applet {
    Panel panel1;
    Panel results;
    Label label1;
    TextField Hin;
    TextField Tin;
    TextField din;
    TextField angle0;
    Button Calculate;
    Button Reset;
    Refract ref;
    Choice torf;
    int ntheory;
    TextField lout;
    TextField Cgout;
    TextField Ksout;
    TextField Krout;
    TextField angleout;
    TextField fin;
    TextField Hshal;
    TextField nout;
    TextField Cout;
    TextField kout;
    TextField ubout;
    boolean period = true;

    public void init() {
        this.resize(450, 450);
        this.setLayout(new BorderLayout());
        this.panel1 = new Panel();
        this.panel1.setLayout(new GridLayout(9, 2));
        this.panel1.add(new Label("Deep Water Values:"));
        this.panel1.add(new Label(" "));
        this.panel1.add(new Label("Wave Height (m)?"));
        this.Hin = new TextField("");
        this.panel1.add(this.Hin);
        this.torf = new Choice();
        this.torf.addItem("Period");
        this.torf.addItem("Frequency (Hz)");
        this.panel1.add(this.torf);
        this.Tin = new TextField("");
        this.panel1.add(this.Tin);
        this.panel1.add(new Label("Wave Angle (o)?"));
        this.angle0 = new TextField("0.0");
        this.panel1.add(this.angle0);
        this.panel1.add(new Label("Local Depth?"));
        this.din = new TextField("");
        this.panel1.add(this.din);
        this.panel1.add(new Label(""));
        this.panel1.add(new Label(""));
        this.panel1.add(new Label(""));
        this.panel1.add(new Label(""));
        this.Calculate = new Button("Calculate");
        this.panel1.add(this.Calculate);
        this.Reset = new Button("Reset");
        this.panel1.add(this.Reset);
        this.panel1.add(new Label(""));
        this.panel1.add(new Label(""));
        this.add("West", this.panel1);
        this.results = new Panel();
        this.results.setLayout(new GridLayout(10, 2));
        this.results.add(new Label(" L (m) ="));
        this.lout = new TextField("           ");
        this.lout.setEditable(false);
        this.results.add(this.lout);
        this.results.add(new Label(" k=2 pi/L = "));
        this.kout = new TextField("           ");
        this.kout.setEditable(false);
        this.results.add(this.kout);
        this.results.add(new Label(" C =L/T = "));
        this.Cout = new TextField("           ");
        this.Cout.setEditable(false);
        this.results.add(this.Cout);
        this.results.add(new Label("  Cg  ="));
        this.Cgout = new TextField("           ");
        this.Cgout.setEditable(false);
        this.results.add(this.Cgout);
        this.results.add(new Label("  n= Cg/C = "));
        this.nout = new TextField("            ");
        this.nout.setEditable(false);
        this.results.add(this.nout);
        this.results.add(new Label("  Ks = "));
        this.Ksout = new TextField("            ");
        this.Ksout.setEditable(false);
        this.results.add(this.Ksout);
        this.results.add(new Label("  Kr = "));
        this.Krout = new TextField("              ");
        this.Krout.setEditable(false);
        this.results.add(this.Krout);
        this.results.add(new Label(" Angle = "));
        this.angleout = new TextField("           ");
        this.angleout.setEditable(false);
        this.results.add(this.angleout);
        this.results.add(new Label("   H = "));
        this.Hshal = new TextField("          ");
        this.Hshal.setEditable(false);
        this.results.add(this.Hshal);
        this.results.add(new Label("  u_b= "));
        this.ubout = new TextField("        ");
        this.ubout.setEditable(false);
        this.results.add(this.ubout);
        this.add("Center", this.results);
    }

    public boolean handleEvent(Event event) {
        this.ref = new Refract();
        try {
            if (event.id == 1001) {
                if (event.target.equals(this.torf)) {
                    this.period = "Period".equals(event.arg);
                }
                if (event.target instanceof Button) {
                    if (event.target == this.Calculate) {
                        float f = Float.valueOf(this.Hin.getText()).floatValue();
                        String string = this.Tin.getText();
                        float f2 = this.period ? Float.valueOf(string).floatValue() : (float)(1.0 / (double)Float.valueOf(string).floatValue());
                        float f3 = Float.valueOf(this.din.getText()).floatValue();
                        float f4 = Float.valueOf(this.angle0.getText()).floatValue();
                        float f5 = this.ref.waveNumber(f3, f2);
                        ((TextComponent)this.kout).setText(String.valueOf(f5));
                        float f6 = 6.283185f / f5;
                        ((TextComponent)this.lout).setText(String.valueOf(f6));
                        float f7 = f6 / f2;
                        ((TextComponent)this.Cout).setText(String.valueOf(f7));
                        float f8 = this.ref.theta(f4, f5, f2);
                        ((TextComponent)this.angleout).setText(String.valueOf(f8));
                        float f9 = this.ref.groupVelocity(f2, f3, f5);
                        float f10 = f9 / f7;
                        ((TextComponent)this.nout).setText(String.valueOf(f10));
                        ((TextComponent)this.Cgout).setText(String.valueOf(f9));
                        float f11 = this.ref.shoalingCoef(f2, f9);
                        ((TextComponent)this.Ksout).setText(String.valueOf(f11));
                        float f12 = this.ref.refractionCoef(f4, f8);
                        ((TextComponent)this.Krout).setText(String.valueOf(f12));
                        float f13 = f11 * f12 * f;
                        if (f13 > 0.8f * f3) {
                            f13 = 0.8f * f3;
                            ((TextComponent)this.Hshal).setText(String.valueOf(String.valueOf(f13)) + ", breaking");
                        } else {
                            ((TextComponent)this.Hshal).setText(String.valueOf(f13));
                        }
                        double d = Math.PI * 2 / (double)f2 * (double)f13 / (2.0 * Hyper.sinh(f5 * f3));
                        ((TextComponent)this.ubout).setText(String.valueOf(d));
                    } else if (event.target == this.Reset) {
                        ((TextComponent)this.Hin).setText("");
                        ((TextComponent)this.Tin).setText("");
                        ((TextComponent)this.din).setText("");
                        ((TextComponent)this.angle0).setText("");
                        ((TextComponent)this.lout).setText("");
                        ((TextComponent)this.kout).setText("");
                        ((TextComponent)this.Cout).setText("");
                        ((TextComponent)this.Cgout).setText("");
                        ((TextComponent)this.nout).setText("");
                        ((TextComponent)this.Ksout).setText("");
                        ((TextComponent)this.Krout).setText("");
                        ((TextComponent)this.kout).setText("");
                        ((TextComponent)this.angleout).setText("");
                        ((TextComponent)this.Hshal).setText("");
                        ((TextComponent)this.ubout).setText("");
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(numberFormatException);
        }
        return false;
    }
}

