/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class WavePlot {
    public int length;
    public int amplitude;
    public int totalh;
    int[] x;
    int[] y;
    public float H;
    public float d;
    public float T;
    public float L;
    int[] depth;
    int[] uc;
    int[] ut;
    int[] vt;
    int[] vc;
    int[] xp;
    int[] yp;
    float dz;
    double dt;
    int dep;
    float famplitude;
    int ncount = 10;
    String waveLength = " ";
    String bottom = " ";
    String umax = " ";
    String vmax = " ";
    public int jstep;
    float[] umag;
    float[] vmag;
    int offset = 5;
    int Depth;
    int temp;

    public WavePlot(int n, int n2) {
        this.length = n;
        this.totalh = n2;
        this.x = new int[this.length + 2];
        this.y = new int[this.length + 2];
        this.uc = new int[this.ncount];
        this.ut = new int[this.ncount];
        this.vc = new int[this.ncount];
        this.vt = new int[this.ncount];
        this.xp = new int[this.ncount];
        this.yp = new int[this.ncount];
        this.umag = new float[this.ncount];
        this.vmag = new float[this.ncount];
        this.depth = new int[this.ncount];
        int n3 = 0;
        while (n3 < this.length) {
            this.x[n3] = 0;
            this.y[n3] = n3;
            ++n3;
        }
    }

    public void initialize(float f, float f2, float f3, float f4) {
        this.L = f2;
        if ((double)this.L > 1.0) {
            this.temp = (int)(100.0 * (double)this.L);
            f2 = (float)((double)this.temp / 100.0);
        } else {
            f2 = (float)((double)((int)(1000.0 * (double)this.L)) / 1000.0);
        }
        this.waveLength = "L= " + f2 + " m";
        this.H = f;
        this.d = f3;
        this.T = f4;
        this.dt = (double)f4 / 30.0;
        this.famplitude = this.H / 2.0f / (this.d + this.H / 2.0f) * (float)(this.totalh - this.offset);
        this.amplitude = (int)this.famplitude;
        this.dz = (this.totalh - this.amplitude - this.offset) / (this.ncount - 1);
    }

    public void do_wave() {
        ++this.jstep;
        double d = Math.PI * 2 / (double)this.T;
        double d2 = Math.PI * 2 / (double)this.L;
        int n = 0;
        while (n < this.length) {
            double d3 = Math.PI * 2 * (double)n / (double)this.length - d * (double)this.jstep * this.dt;
            this.x[n] = this.offset + this.amplitude - (int)((double)this.amplitude * Math.cos(d3));
            ++n;
        }
        double d4 = Hyper.cosh(d2 * (double)this.d);
        double d5 = Math.cos(-d * (double)this.jstep * this.dt);
        double d6 = Math.sin(-d * (double)this.jstep * this.dt);
        int n2 = 0;
        while (n2 < this.ncount) {
            double d7 = (float)(this.ncount - 1 - n2) * this.d / (float)(this.ncount - 1);
            this.depth[n2] = this.offset + this.amplitude + (int)((float)n2 * this.dz);
            this.umag[n2] = (float)((double)this.totalh * Hyper.cosh(d2 * d7) / (d4 * 15.0));
            this.vmag[n2] = (float)((double)this.totalh * Hyper.sinh(d2 * d7) / (d4 * 15.0));
            this.uc[n2] = (int)((double)this.umag[n2] * d5);
            this.xp[n2] = (int)((double)this.umag[n2] * d6);
            this.ut[n2] = -this.uc[n2];
            this.vc[n2] = (int)((double)this.vmag[n2] * d6);
            this.yp[n2] = -((int)((double)this.vmag[n2] * d5));
            this.vt[n2] = -this.vc[n2];
            ++n2;
        }
        double d8 = 9.81 * d2 * 15.0 * ((double)this.H / 2.0) / (d * (double)this.totalh);
        this.umax = "u_max= " + (double)((int)((double)this.umag[0] * d8 * 100.0)) / 100.0 + " m/s";
        this.vmax = "v_max= " + (double)((int)((double)this.vmag[0] * d8 * 100.0)) / 100.0 + " m/s";
    }

    public void Draw(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawLine(0, this.amplitude + this.offset, this.length, this.amplitude + this.offset);
        graphics.drawLine(0, 0, 0, this.totalh);
        int n = this.length - 1;
        int n2 = this.totalh - 1;
        graphics.drawLine(0, n2, n, n2);
        graphics.drawLine(n, 0, n, n);
        graphics.drawLine(0, 0, n, 0);
        graphics.setColor(Color.blue);
        this.x[this.length] = this.totalh;
        this.x[this.length + 1] = this.totalh;
        this.y[this.length] = this.length - 1;
        this.y[this.length + 1] = 0;
        graphics.fillPolygon(this.y, this.x, this.length + 2);
        int n3 = 0;
        while (n3 < this.ncount) {
            graphics.setColor(Color.white);
            this.Depth = this.depth[n3];
            graphics.drawLine(0, this.Depth, this.uc[n3], this.Depth - this.vc[n3]);
            graphics.drawLine(n / 2, this.Depth, n / 2 + this.ut[n3], this.Depth - this.vt[n3]);
            graphics.drawLine(n, this.Depth, n + this.uc[n3], this.Depth - this.vc[n3]);
            int n4 = (int)this.vmag[n3];
            int n5 = (int)this.umag[n3];
            graphics.drawOval(n / 2 - n5, this.Depth - n4, 2 * n5, 2 * n4);
            graphics.drawOval(-n5, this.Depth - n4, 2 * n5, 2 * n4);
            graphics.drawOval(n - n5, this.Depth - n4, 2 * n5, 2 * n4);
            graphics.fillOval(-this.xp[n3], this.Depth + this.yp[n3], 4, 4);
            graphics.fillOval(n / 2 + this.xp[n3], this.Depth - this.yp[n3], 4, 4);
            graphics.fillOval(n - this.xp[n3], this.Depth + this.yp[n3], 4, 4);
            ++n3;
        }
        n = this.length - 130;
        n2 = this.amplitude + 80;
        graphics.setColor(Color.yellow);
        graphics.drawString(this.waveLength, n, n2);
        graphics.drawString(this.umax, n, n2 += 20);
        graphics.drawString(this.vmax, n, n2 += 20);
    }

    public void update(Graphics graphics) {
        this.Draw(graphics);
    }
}

